<?php
/**
 * Make First Letter Uppercase 1.2
 * Copyright 2011 Fábio Maia, All Rights Reserved
 */
 
// Disallow direct access to this file for security reasons
if(!defined("IN_MYBB"))
{
    	die("Direct initialization of this file is not allowed.<br /><br />Please make sure IN_MYBB is defined.");
}

$plugins->add_hook("datahandler_post_insert_thread", "mfluc_newthreads");
$plugins->add_hook("datahandler_post_insert_thread_post", "mfluc_newposts");
$plugins->add_hook("datahandler_post_insert_post", "mfluc_newposts");
$plugins->add_hook("datahandler_post_update_thread", "mfluc_editthreads");
$plugins->add_hook("datahandler_post_update", "mfluc_editposts");
$plugins->add_hook("datahandler_post_update_thread", "mfluc_editposts");

function mfluc_info()
{
	return array(
		"name"			=> "هاك تغيير اول حرف كابتل",
		"description"	=> "يقوم بتغيير اول حرف من عنوان الموضوع والموضوع الي كابتل",
		"website"		=> "http://mybb.com",
		"author"		=> "F&#225;bio Maia",
		"authorsite"	=> "http://community.mybb.com/user-16693.html",
		"version"		=> "1.2",
		"guid" 			=> "34d6c931668bee7a1ea6a1d84db8a910",
		"compatibility" => "14*,16*"
	);
}

// Activate function
function mfluc_activate()
{
	global $db;
	
	// Insert settings group
	$mfluc_settingsgroup = array(
		"gid"    => "NULL",
		"name"  => "mfluc_settingsgroup",
		"title"      => "هاك تغيير اول حرف الي كابتل",
		"description"    => "اعدادات الهاك.",
		"disporder"    => "1",
		"isdefault"  => "no",
	);

	$db->insert_query("settinggroups", $mfluc_settingsgroup);
	$gid = $db->insert_id();

  	// Insert yes or no threads setting
	$mfluc_capitalthreads = array(
		"sid"            => "NULL",
		"name"        => "mfluc_capitalthreads",
		"title"            => "تغير اول حرف للعنوان",
		"description"    => "اختار نعم ان احببت تغير اول حرف بعنوان الموضوع الي كابتل.",
		"optionscode"    => "yesno",
		"value"        => "1",
		"disporder"        => "1",
		"gid"            => intval($gid),
	);

	$db->insert_query("settings", $mfluc_capitalthreads);
  	rebuild_settings();
  	
	// Insert yes or no post setting
	$mfluc_capitalposts = array(
		"sid"            => "NULL",
		"name"        => "mfluc_capitalposts",
		"title"            => "تغيير اول حرف للموضوع",
		"description"    => "اختار نعم ان احببت تغيير اول حرف للموضوع الي كابتل.",
		"optionscode"    => "yesno",
		"value"        => "1",
		"disporder"        => "1",
		"gid"            => intval($gid),
	);
	
	$db->insert_query("settings", $mfluc_capitalposts);
  	rebuild_settings();
}

// New threads
function mfluc_newthreads($datahandler)
{
	global $mybb, $db;
	
	if ($mybb->settings['mfluc_capitalthreads'] == 1)
	{
		$datahandler->thread_insert_data['subject'] = ucfirst($datahandler->thread_insert_data['subject']);
	}
}

// New posts
function mfluc_newposts($datahandler)
{
	global $mybb, $db;
	
	if ($mybb->settings['mfluc_capitalposts'] == 1)
	{
		$datahandler->post_insert_data['subject'] = ucfirst($datahandler->post_insert_data['subject']);
		$datahandler->post_insert_data['message'] = ucfirst($datahandler->post_insert_data['message']);
		$datahandler->post_update_data['subject'] = ucfirst($datahandler->post_update_data['subject']);
		$datahandler->post_update_data['message'] = ucfirst($datahandler->post_update_data['message']);
	}
}

// Edit threads
function mfluc_editthreads($datahandler)
{
	global $mybb, $db;

	if ($mybb->settings['mfluc_capitalthreads'] == 1 && $datahandler->thread_update_data['subject'])
	{
		$datahandler->thread_update_data['subject'] = ucfirst($datahandler->thread_update_data['subject']);
	}
}

// Edit posts
function mfluc_editposts($datahandler)
{
	global $mybb, $db;
	
	if ($mybb->settings['mfluc_capitalposts'] == 1)
	{
		if($datahandler->post_update_data['subject'] && $datahandler->thread_update_data['subject'])
		{
			$datahandler->post_update_data['subject'] = ucfirst($datahandler->post_update_data['subject']);
		}
		
		if($datahandler->post_update_data['subject'] && $datahandler->post_update_data['message'])
		{
			$datahandler->post_update_data['message'] = ucfirst($datahandler->post_update_data['message']);
		}
	}
}

function mfluc_deactivate()
{
	global $db;
	
	$db->query("DELETE FROM ".TABLE_PREFIX."settings WHERE name IN('mfluc_capitalposts', 'mfluc_settingsgroup')");
	$db->query("DELETE FROM ".TABLE_PREFIX."settings WHERE name IN('mfluc_capitalthreads', 'mfluc_settingsgroup')");
    	$db->query("DELETE FROM ".TABLE_PREFIX."settinggroups WHERE name='mfluc_settingsgroup'");
	rebuildsettings();
}
?>
